Attribute VB_Name = "mdlSimulate"
'********************************************************************************
'
'                       C O P Y R I G H T  (c) 2004
'               N O R T H E R N    D Y N A M I C   I N C.
'                           All Rights Reserved.
'   ........................................................................
'   This sample code is provided by Northern Dynamic solely to assist in
'   understanding the use of the SLIK-DA ActiveX Control. This code is
'   provided as-is and without warranty or support of any sort.
'
'********************************************************************************
'
'   Project:        SLIK-DA ActiveX Control
'
'   Description:    This sample server application is based on Northern Dynamic's
'                   Simple Language Independent Toolkit for creating OPC
'                   Data Access servers (SLIK-DA). This implementation illustrates
'                   the use of various features of the SLIK-DA ActiveX Control.
'
'   Revision:
'       02-10-31    gde     Initial release.
'       04-09-30    gde     Modified for DA V3.00 support
'
'********************************************************************************
Option Explicit

Public Sub UpdateTags( _
    Tags As NDISLIKDACtl.ISLIKTags _
    )
    
    '
    ' A real server might scan one or more devices here to update the Tags.
    ' This server does not communicate with any hardware, so instead we will
    ' simulate data changes.
    '
   
    Dim Tag As NDISLIKDACtl.ISLIKTag
    Dim nIndex As Integer
    
    ' Update each SLIKTag in the SLIKTags collection.
    For Each Tag In Tags
        '
        ' Simulate data changes for each tag that meets the following criteria:
        '   1. The tag is currently active.
        '   2. The tag's access permessions are read-only.
        '
        If Tag.Active And (Tag.AccessPermissions = sdaReadAccess) Then
            Call SimulateDataChange(Tag, sdaGood)
        Else
            ' Update the quality (and timestamp) for the other tags
            Call Tag.SetVQT(, sdaGood)
        End If
    Next
    
End Sub

Public Sub ReadTags( _
    ByVal Count As Long, _
    Tags() As NDISLIKDACtl.ISLIKTag, _
    Errors() As Long, _
    Result As Long _
)

    '
    ' A real server might have to read one or more devices here to service the
    ' Read request.  This server does not communicate with any hardware.
    ' Instead, we rely on the periodic tag update to simulate data changes, so
    ' this Read call will be basically a no-op.
    
    Dim Tag As NDISLIKDACtl.ISLIKTag
    Dim nIndex As Integer
    Dim sSrcPrefix As String
    
    ' Update the tag level error codes.
    Debug.Assert (LBound(Tags) = 0)
    For nIndex = 0 To Count - 1     ' Arrays from SLIK-DA are always 0-based.
        ' For this server, Tag reads always succeed!
        Errors(nIndex) = sdaSOK
    Next nIndex
    
    ' Return overall status.  For this server, the overall Read status is
    ' always sdaSOK.  A real server should set this according to the tag level
    ' read results.
    Result = sdaSOK

End Sub

Public Sub WriteTagValues( _
    ByVal Count As Long, _
    Tags() As NDISLIKDACtl.ISLIKTag, _
    Values() As Variant, _
    Errors() As Long, _
    Result As Long _
)
    ' Our simulation server does not talk to any hardware, so we just proceed to
    ' write the new values provided to the corresponding Tag.  A real server may
    ' validate the data first (e.g. range checking), scale the data, etc. before
    ' performing the actual write to the underlying system/hardware.

    Dim i As Integer
    
    ' Update each tag
    Debug.Assert (LBound(Tags) = 0)
    For i = 0 To Count - 1     ' Arrays from SLIK-DA are always 0-based.
        Call Tags(i).SetVQT(Values(i), sdaGood)
        Errors(i) = sdaSOK
    Next i
    
    ' Return overall status.  For this server, the overall Write status is
    ' always sdaSOK.  A real server should set this according to the tag level
    ' write results.
    Result = sdaSOK

End Sub

Public Sub WriteTagVQTs( _
    ByVal Count As Long, _
    Tags() As NDISLIKDACtl.ISLIKTag, _
    Values() As Variant, _
    Qualities() As Integer, _
    Timestamps() As Date, _
    Errors() As Long, _
    Result As Long _
)
    ' Our simulation server will allow any combination of VQT to be
    ' written.
    
    Dim i As Integer
        
    ' Update each tag
    Debug.Assert (LBound(Tags) = 0)
    For i = 0 To Count - 1     ' Arrays from SLIK-DA are always 0-based.
        Call Tags(i).SetVQT(Values(i), Qualities(i), Timestamps(i))
        Errors(i) = sdaSOK
    Next i
    
    Result = sdaSOK

End Sub

Private Sub SimulateDataChange( _
    Tag As NDISLIKDACtl.ISLIKTag, _
    nQuality As Integer _
    )
    
    Dim varValue As Variant
    varValue = Tag.Value
    
    Select Case Tag.DataType
    Case vbBoolean
        varValue = Not varValue
    Case vbByte
        If (varValue > 250) Then
            varValue = 0
        Else
            varValue = varValue + 1
        End If
    Case vbInteger
        If (varValue > 10000) Then
            varValue = -10000
        Else
            varValue = varValue + 4
        End If
    Case vbLong
        If (varValue > 1000000) Then
            varValue = -1000000
        Else
            varValue = varValue + 9
        End If
    Case vbSingle
        If (varValue > 1E+20) Then
            varValue = -1E+20
        End If
        If (varValue > 0) Then
            varValue = varValue * 1.1
        Else
            varValue = (varValue / 1.1) + 1
        End If
    Case vbDouble
        If (varValue > 1E+50) Then
            varValue = -1E+50
        End If
        If (varValue > 0) Then
            varValue = varValue * 1.2
        Else
            varValue = (varValue / 1.2) + 1
        End If
    Case vbCurrency
        If (varValue > 1000000000) Then
            varValue = -1000000000
        End If
        If (varValue > 0) Then
            varValue = (varValue * 1.1) + 3.4567
        Else
            varValue = (varValue / 1.1) + 3.4567
        End If
    Case vbDate
        varValue = Now
    Case vbString
        varValue = "Current time is " & CStr(Now)
    Case Else
        ' Simulation for data type not supported
    End Select

    ' Now set the Value, Quality, and Timestamp
    ' Note: By NOT passing the optional timestamp to SetVQT()
    '       SLIK-DA will use the current system time,
    '       and generate a timestamp with millisecond resolution.
    '       VB's Now() function, only gives 1 second
    '       resolution.  In a real server, the timestamp would
    '       more likely come from the underlying system.
    Call Tag.SetVQT(varValue, nQuality)
        
End Sub

